/*
 * Decompiled with CFR 0.152.
 */
package panther.util.general;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashSet;
import panther.util.general.DevOut;
import panther.util.general.ErrorUtils;

public class ReflectiveUtils {
    public static Object safeEvaluate(Object object, String string, Class[] classArray, Object[] objectArray) {
        try {
            return ReflectiveUtils.evaluate(object, string, classArray, objectArray);
        }
        catch (Throwable throwable) {
            ErrorUtils.checkIgnore(throwable);
            DevOut.trace(throwable);
            throw new Error("Unable to evaluate method " + string + " on " + object);
        }
    }

    public static Object safeInstantiate(String string, String string2) {
        try {
            return ReflectiveUtils.instantiate(string2);
        }
        catch (Throwable throwable) {
            if (throwable instanceof ThreadDeath) {
                throw (ThreadDeath)throwable;
            }
            DevOut.trace(throwable);
            throw new Error("FATAL ERROR: Unable to instantiate " + string + " from class " + string2);
        }
    }

    public static Object safeInstantiate(String string, String string2, String string3, Object object) {
        String[] stringArray = new String[]{string3};
        Object[] objectArray = new Object[]{object};
        try {
            return ReflectiveUtils.instantiate(string2, stringArray, objectArray);
        }
        catch (Throwable throwable) {
            if (throwable instanceof ThreadDeath) {
                throw (ThreadDeath)throwable;
            }
            DevOut.trace(throwable);
            throw new Error("FATAL ERROR: Unable to instantiate " + string + " from class " + string2);
        }
    }

    public static Object safeInstantiate(String string, String string2, Object[] objectArray) {
        try {
            return ReflectiveUtils.instantiate(string2, objectArray);
        }
        catch (Throwable throwable) {
            if (throwable instanceof ThreadDeath) {
                throw (ThreadDeath)throwable;
            }
            DevOut.trace(throwable);
            throw new Error("FATAL ERROR: Unable to instantiate " + string + " from class " + string2);
        }
    }

    public static Object safeInstantiate(String string, String string2, Class[] classArray, Object[] objectArray) {
        try {
            return ReflectiveUtils.instantiate(string2, classArray, objectArray);
        }
        catch (Throwable throwable) {
            if (throwable instanceof ThreadDeath) {
                throw (ThreadDeath)throwable;
            }
            DevOut.trace(throwable);
            throw new Error("FATAL ERROR: Unable to instantiate " + string + " from class " + string2);
        }
    }

    public static Object instantiate(String string) throws ClassNotFoundException, NoSuchMethodException, InstantiationException, IllegalAccessException, InvocationTargetException {
        return ReflectiveUtils.instantiate(string, new Class[0], new Object[0]);
    }

    public static Object instantiate(String string, Object[] objectArray) throws ClassNotFoundException, NoSuchMethodException, InstantiationException, IllegalAccessException, InvocationTargetException {
        return ReflectiveUtils.instantiate(Class.forName(string), objectArray);
    }

    public static Object instantiate(String string, String string2, Object object) throws ClassNotFoundException, NoSuchMethodException, InstantiationException, IllegalAccessException, InvocationTargetException {
        String[] stringArray = new String[]{string2};
        Object[] objectArray = new Object[]{object};
        return ReflectiveUtils.instantiate(string, stringArray, objectArray);
    }

    public static Object instantiate(String string, String[] stringArray, Object[] objectArray) throws ClassNotFoundException, NoSuchMethodException, InstantiationException, IllegalAccessException, InvocationTargetException {
        return ReflectiveUtils.instantiate(Class.forName(string), stringArray, objectArray);
    }

    public static Object instantiate(Class clazz, String[] stringArray, Object[] objectArray) throws ClassNotFoundException, NoSuchMethodException, InstantiationException, IllegalAccessException, InvocationTargetException {
        Class[] classArray = new Class[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            classArray[i] = Class.forName(stringArray[i]);
        }
        return ReflectiveUtils.instantiate(clazz, classArray, objectArray);
    }

    public static Object instantiate(String string, Class[] classArray, Object[] objectArray) throws ClassNotFoundException, NoSuchMethodException, InstantiationException, IllegalAccessException, InvocationTargetException {
        return ReflectiveUtils.instantiate(Class.forName(string), classArray, objectArray);
    }

    public static Object instantiate(Class clazz) throws ClassNotFoundException, NoSuchMethodException, InstantiationException, IllegalAccessException, InvocationTargetException {
        return ReflectiveUtils.instantiate(clazz, new Class[0], new Object[0]);
    }

    public static Object instantiate(Class clazz, Object[] objectArray) throws ClassNotFoundException, NoSuchMethodException, InstantiationException, IllegalAccessException, InvocationTargetException {
        Class[] classArray = new Class[objectArray.length];
        for (int i = 0; i < objectArray.length; ++i) {
            classArray[i] = objectArray[i].getClass();
        }
        return ReflectiveUtils.instantiate(clazz, classArray, objectArray);
    }

    public static Object instantiate(Class clazz, Class[] classArray, Object[] objectArray) throws ClassNotFoundException, NoSuchMethodException, InstantiationException, IllegalAccessException, InvocationTargetException {
        Constructor constructor = clazz.getConstructor(classArray);
        return constructor.newInstance(objectArray);
    }

    public static Object evaluate(Object object, String string, Class[] classArray, Object[] objectArray) throws ClassNotFoundException, NoSuchMethodException, InstantiationException, IllegalAccessException, InvocationTargetException {
        Method method = object.getClass().getMethod(string, classArray);
        return method.invoke(object, objectArray);
    }

    public static Object[] traverse(Class clazz) {
        Object[] objectArray;
        HashSet<Object> hashSet = new HashSet<Object>();
        ArrayList arrayList = new ArrayList();
        for (Class clazz2 = clazz; clazz2 != null; clazz2 = clazz2.getSuperclass()) {
            arrayList.add(clazz2);
            objectArray = clazz2.getInterfaces();
            for (int i = 0; i < objectArray.length; ++i) {
                hashSet.add(objectArray[i]);
            }
        }
        objectArray = new Object[]{arrayList, hashSet};
        return objectArray;
    }
}

